/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common.nbsplayer;

import io.github.kosmx.emotes.common.network.CommonNetwork;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import net.raphimc.noteblocklib.data.MinecraftInstrument;
import net.raphimc.noteblocklib.format.nbs.NbsDefinitions;
import net.raphimc.noteblocklib.format.nbs.model.NbsLayer;
import net.raphimc.noteblocklib.format.nbs.model.NbsNote;
import net.raphimc.noteblocklib.format.nbs.model.NbsSong;
import net.raphimc.noteblocklib.model.Note;
import net.raphimc.noteblocklib.model.instrument.Instrument;

@Deprecated
public class LegacyNBSPacket {
    public static void write(NbsSong song, ByteBuf buf) {
        buf.writeInt(1);
        buf.writeByte(0);
        buf.writeByte((int)((byte)song.getVanillaInstrumentCount()));
        buf.writeShort((int)song.getTempo());
        buf.writeByte((int)song.getTimeSignature());
        CommonNetwork.writeBoolean(buf, song.isLoop());
        buf.writeByte((int)song.getMaxLoopCount());
        buf.writeShort((int)song.getLoopStartTick());
        buf.writeShort((int)((short)song.getLayers().size()));
        LegacyNBSPacket.writeLayersAndNotes(song, buf);
    }

    private static void writeLayersAndNotes(NbsSong song, ByteBuf buf) {
        for (Map.Entry layerEntry : song.getLayers().entrySet()) {
            NbsLayer layer = (NbsLayer)layerEntry.getValue();
            buf.writeByte((int)layer.getVolume());
            buf.writeByte((int)((byte)layer.getPanning()));
            int tick = -1;
            for (Map.Entry noteEntry : layer.getNotes().entrySet()) {
                NbsNote note = (NbsNote)noteEntry.getValue();
                buf.writeShort((int)((short)((Integer)noteEntry.getKey() - tick)));
                tick = (Integer)noteEntry.getKey();
                buf.writeByte((int)((byte)note.getInstrument()));
                buf.writeByte((int)note.getKey());
                buf.writeByte((int)note.getVelocity());
                buf.writeByte((int)((byte)note.getPanning()));
                buf.writeShort((int)note.getPitch());
            }
            buf.writeShort(0);
        }
    }

    public static NbsSong read(ByteBuf buf) throws IOException {
        buf.readInt();
        buf.readByte();
        NbsSong builder = new NbsSong();
        builder.setVersion((byte)5);
        builder.setVanillaInstrumentCount((int)buf.readByte());
        builder.setTempo(buf.readShort());
        builder.setTimeSignature(buf.readByte());
        builder.setLoop(CommonNetwork.readBoolean(buf));
        builder.setMaxLoopCount(buf.readByte());
        builder.setLoopStartTick(buf.readShort());
        builder.setLayerCount(buf.readShort());
        LegacyNBSPacket.readLayersAndNotes(builder, buf);
        return builder;
    }

    private static void readLayersAndNotes(NbsSong song, ByteBuf buf) {
        NbsNote note;
        Map layers = song.getLayers();
        if (song.getLayerCount() != layers.size()) {
            if (!layers.isEmpty()) {
                return;
            }
            for (int i = 0; i < song.getLayerCount(); ++i) {
                layers.put(i, new NbsLayer());
            }
        }
        int length = 0;
        for (Map.Entry layerEntry : layers.entrySet()) {
            NbsLayer layer = (NbsLayer)layerEntry.getValue();
            layer.setVolume(buf.readByte());
            layer.setPanning((short)buf.readByte());
            int tick = -1;
            short step = buf.readShort();
            while (step != 0) {
                tick += step;
                note = new NbsNote();
                note.setInstrument((short)buf.readByte());
                note.setKey(buf.readByte());
                note.setVelocity(buf.readByte());
                note.setPanning((short)buf.readByte());
                note.setPitch(buf.readShort());
                layer.getNotes().put(tick, note);
                length = Math.max(length, tick);
                step = buf.readShort();
            }
        }
        song.setLength((short)length);
        song.getTempoEvents().set(0, (float)song.getTempo() / 100.0f);
        for (NbsLayer layer : layers.values()) {
            for (Map.Entry noteEntry : layer.getNotes().entrySet()) {
                NbsNote nbsNote = (NbsNote)noteEntry.getValue();
                note = new Note();
                note.setNbsKey((float)NbsDefinitions.getEffectivePitch((NbsNote)nbsNote) / 100.0f);
                note.setVolume((float)layer.getVolume() / 100.0f * ((float)nbsNote.getVelocity() / 100.0f));
                if (layer.getPanning() == 100) {
                    note.setPanning((float)(nbsNote.getPanning() - 100) / 100.0f);
                } else {
                    note.setPanning((float)(layer.getPanning() - 100 + (nbsNote.getPanning() - 100)) / 200.0f);
                }
                if (nbsNote.getInstrument() < song.getVanillaInstrumentCount()) {
                    note.setInstrument((Instrument)MinecraftInstrument.fromNbsId((byte)((byte)nbsNote.getInstrument())));
                }
                song.getNotes().add(((Integer)noteEntry.getKey()).intValue(), (Note)note);
            }
        }
    }
}

