/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.modmenu;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.lopymine.patpat.PatTranslation;
import net.lopymine.patpat.client.PatPatClient;
import net.lopymine.patpat.utils.ModMenuUtils;
import net.lopymine.patpat.utils.TextUtils;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class NoConfigLibrariesScreen {
    private static final String YACL_MODRINTH_LINK = "https://modrinth.com/mod/yacl?version=%s&loader=fabric#download";
    private static final String CLOTH_CONFIG_API_MODRINTH_LINK = "https://modrinth.com/mod/cloth-config?version=%s&loader=fabric#download";
    private static final class_2561 TITLE;
    private static final class_2561 MESSAGE;
    private static final class_2561 OPEN_YACL_PAGE;
    private static final class_2561 OPEN_CLOTH_CONFIG_PAGE;
    private static final Set<String> ALLOWED_PROTOCOLS;

    private NoConfigLibrariesScreen() {
        throw new IllegalStateException("Screen class, use NoConfigLibrariesScreen.createScreen(...) method!");
    }

    public static class_437 createScreen(final class_437 parent) {
        return new class_410(NoConfigLibrariesScreen::onConfirm, TITLE, MESSAGE, OPEN_YACL_PAGE, OPEN_CLOTH_CONFIG_PAGE){

            public boolean method_25404(class_11908 keyEvent) {
                if (keyEvent.comp_4795() == 256 && this.method_25422()) {
                    class_310.method_1551().method_1507(parent);
                    return true;
                }
                return super.method_25404(keyEvent);
            }

            public boolean method_25422() {
                return true;
            }
        };
    }

    private static void onConfirm(boolean bl) {
        try {
            String url = (bl ? YACL_MODRINTH_LINK : CLOTH_CONFIG_API_MODRINTH_LINK).formatted(class_155.method_16673().comp_4025());
            URI link = new URI(url);
            String string = link.getScheme();
            if (string == null) {
                throw new URISyntaxException(url, "Missing protocol");
            }
            if (!ALLOWED_PROTOCOLS.contains(string.toLowerCase(Locale.ROOT))) {
                throw new URISyntaxException(url, "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
            }
            class_156.method_668().method_673(link);
        }
        catch (URISyntaxException e) {
            PatPatClient.LOGGER.error("Can't open {} Modrinth page: ", bl ? "YACL" : "Cloth Config API", e);
        }
    }

    static {
        ALLOWED_PROTOCOLS = Set.of("http", "https");
        class_5250 yaclShort = TextUtils.literal("YACL").method_27692(class_124.field_1065);
        class_5250 yaclFull = TextUtils.literal("Yet Another Config Lib [YACL]").method_27692(class_124.field_1065);
        class_5250 clothConfig = TextUtils.literal("Cloth Config API").method_27692(class_124.field_1065);
        class_5250 closeText = PatTranslation.text("modmenu.no_config_libraries_screen.close", new Object[0]).method_27692(class_124.field_1080);
        TITLE = ModMenuUtils.getModTitle();
        MESSAGE = PatTranslation.text("modmenu.no_config_libraries_screen.message", yaclFull, clothConfig).method_27693("\n\n").method_10852((class_2561)closeText);
        OPEN_YACL_PAGE = PatTranslation.text("modmenu.no_config_libraries_screen.open_page", yaclShort);
        OPEN_CLOTH_CONFIG_PAGE = PatTranslation.text("modmenu.no_config_libraries_screen.open_page", clothConfig);
    }
}

