/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.packet;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.lopymine.patpat.packet.BasePatPatPacket;
import net.lopymine.patpat.packet.PatPatPacketType;
import net.lopymine.patpat.packet.PingPatPacket;
import net.lopymine.patpat.packet.PongPatPacket;

public class PatPatClientNetworkManager {
    public static <T extends BasePatPatPacket<T>> void registerReceiver(PatPatPacketType<T> id, PacketListener<T> listener) {
        ClientPlayNetworking.registerGlobalReceiver(id.getPacketId(), (packet, context) -> {
            PacketSender responseSender = context.responseSender();
            if (packet instanceof PingPatPacket) {
                PingPatPacket pingPacket = (PingPatPacket)packet;
                pingPacket.setPacketSender(responseSender);
            }
            listener.call(packet);
        });
    }

    public static void sendPacketToServer(BasePatPatPacket<?> packet) {
        PongPatPacket pingPong;
        if (packet instanceof PongPatPacket && (pingPong = (PongPatPacket)packet).canPong()) {
            pingPong.pong(packet);
        } else {
            ClientPlayNetworking.send(packet);
        }
    }

    public static interface PacketListener<T> {
        public void call(T var1);
    }
}

