/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.patpat.client.config.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.lopymine.patpat.client.resourcepack.PatPatClientSoundManager;
import net.lopymine.patpat.utils.SoundUtils;
import net.minecraft.class_3414;

public class SoundConfig {
    public static final SoundConfig PAT_PAT_SOUND = new SoundConfig(PatPatClientSoundManager.getPatPatSoundEvent(), 1.0f, 1.0f, 1.0f);
    public static final Codec<SoundConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.xmap(SoundUtils::getSoundEvent, SoundUtils::getLocation).fieldOf("id").forGetter(SoundConfig::getSound), (App)Codec.FLOAT.optionalFieldOf("min_pitch", (Object)Float.valueOf(-1.0f)).forGetter(SoundConfig::getMinPitch), (App)Codec.FLOAT.optionalFieldOf("max_pitch", (Object)Float.valueOf(-1.0f)).forGetter(SoundConfig::getMaxPitch), (App)Codec.FLOAT.optionalFieldOf("minPitch", (Object)Float.valueOf(-1.0f)).forGetter(SoundConfig::getMinPitch), (App)Codec.FLOAT.optionalFieldOf("maxPitch", (Object)Float.valueOf(-1.0f)).forGetter(SoundConfig::getMaxPitch), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(SoundConfig::getVolume)).apply((Applicative)instance, (event, minPitch, maxPitch, minPitchTwo, maxPitchTwo, volume) -> {
        float minP;
        float f = minPitch.floatValue() == -1.0f ? (minPitchTwo.floatValue() == -1.0f ? 1.0f : minPitchTwo.floatValue()) : (minP = minPitch.floatValue());
        float maxP = maxPitch.floatValue() == -1.0f ? (maxPitchTwo.floatValue() == -1.0f ? 1.0f : maxPitchTwo.floatValue()) : maxPitch.floatValue();
        return new SoundConfig((class_3414)event, minP, maxP, volume.floatValue());
    }));
    public static final Codec<SoundConfig> STRINGED_CODEC = Codec.either(CODEC, (Codec)Codec.STRING).xmap(either -> {
        if (either.left().isPresent()) {
            return (SoundConfig)either.left().get();
        }
        if (either.right().isPresent()) {
            return new SoundConfig((String)either.right().get());
        }
        return null;
    }, soundConfig -> {
        if (soundConfig.getMinPitch() == 1.0f && soundConfig.getMaxPitch() == 1.0f && soundConfig.getVolume() == 1.0f) {
            return Either.right((Object)SoundUtils.getLocation(soundConfig.getSound()));
        }
        return Either.left((Object)soundConfig);
    });
    private final class_3414 sound;
    private final float minPitch;
    private final float maxPitch;
    private final float volume;

    public SoundConfig(class_3414 soundEvent, float minPitch, float maxPitch, float volume) {
        this.sound = soundEvent;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        this.volume = volume;
    }

    public SoundConfig(String sound) {
        this.sound = SoundUtils.getSoundEvent(sound);
        this.minPitch = 1.0f;
        this.maxPitch = 1.0f;
        this.volume = 1.0f;
    }

    public String toString() {
        return "SoundConfig{sound=" + SoundUtils.getLocation(this.sound) + ", minPitch=" + this.minPitch + ", maxPitch=" + this.maxPitch + ", volume=" + this.volume + "}";
    }

    @Generated
    public class_3414 getSound() {
        return this.sound;
    }

    @Generated
    public float getMinPitch() {
        return this.minPitch;
    }

    @Generated
    public float getMaxPitch() {
        return this.maxPitch;
    }

    @Generated
    public float getVolume() {
        return this.volume;
    }
}

