/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api;

import eu.pb4.placeholders.api.node.parent.DynamicShadowNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public final class ParserContext {
    private Map<Key<?>, Object> map;
    private boolean copyOnWrite;
    private boolean hasNodeContext;

    private ParserContext(Map<Key<?>, Object> map, boolean copyOnWrite, boolean hasNodeContext) {
        this.map = map;
        this.copyOnWrite = copyOnWrite;
        this.hasNodeContext = hasNodeContext;
    }

    public static ParserContext of() {
        return new ParserContext(new HashMap(), false, false);
    }

    public static <T> ParserContext of(Key<T> key, T object) {
        return ParserContext.of().with(key, object);
    }

    public <T> ParserContext with(Key<T> key, T object) {
        if (this.copyOnWrite) {
            this.map = new HashMap(this.map);
            this.copyOnWrite = false;
        }
        this.map.put(key, object);
        this.hasNodeContext |= key.nodeContext();
        return this;
    }

    @Nullable
    public <T> T get(Key<T> key) {
        return (T)this.map.get(key);
    }

    public <T> T getOrElse(Key<T> key, T defaultValue) {
        return (T)this.map.getOrDefault(key, defaultValue);
    }

    public <T> T getOrElse(Key<T> key, Supplier<T> defaultValue) {
        Object x = this.map.get(key);
        if (x == null) {
            return defaultValue.get();
        }
        return (T)x;
    }

    public <T> T getOrThrow(Key<T> key) {
        return (T)Objects.requireNonNull(this.map.get(key));
    }

    public boolean contains(Key<?> key) {
        return this.map.containsKey(key);
    }

    public ParserContext copy() {
        this.copyOnWrite = true;
        return new ParserContext(this.map, true, this.hasNodeContext);
    }

    public ParserContext copyWithoutNodeContext() {
        if (this.hasNodeContext) {
            HashMap map = new HashMap();
            for (Key<?> key : this.map.keySet()) {
                if (key.nodeContext()) continue;
                map.put(key, this.map.get(key));
            }
            return new ParserContext(map, false, false);
        }
        return this.copy();
    }

    public record Key<T>(String key, @Nullable Class<T> type, boolean nodeContext) {
        public static final Key<Boolean> COMPACT_TEXT = new Key<Boolean>("compact_text", Boolean.class);
        public static final Key<class_7225.class_7874> WRAPPER_LOOKUP = new Key<class_7225.class_7874>("wrapper_lookup", class_7225.class_7874.class);
        public static final Key<DynamicShadowNode.Transformer> DEFAULT_SHADOW_STYLER = Key.ofNode("default_shadow_styler");

        public Key(String key, @Nullable Class<T> type) {
            this(key, type, false);
        }

        public static <T> Key<T> of(String key, T type) {
            return new Key(key, type.getClass(), false);
        }

        public static <T> Key<T> of(String key) {
            return new Key<T>(key, null, false);
        }

        public static <T> Key<T> ofNode(String key, T type) {
            return new Key(key, type.getClass(), true);
        }

        public static <T> Key<T> ofNode(String key) {
            return new Key<T>(key, null, true);
        }
    }
}

